﻿//////////////////////////////////////////////
// LogManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkLog
{
	class Logger ;
}

namespace nkMemory
{
	class StringView ;
}

/// Includes ---------------------------------

// nkResources
#include "../Dll/DllDefines.h"

// Common
#include <nilkinsCommon/Patterns/SingletonClass.h>

/// Class ------------------------------------

namespace nkResources
{
	class DLL_RESOURCES_EXPORT LogManager final : public nkCommon::SingletonClass<LogManager>
	{			
		public :

			// Setters
			void setReceiver (nkLog::Logger* receiver) ;

			// Getters
			nkLog::Logger* getReceiver () const ;

			// Log
			void log (nkMemory::StringView message, nkMemory::StringView className) ;

		private :

			// Constructeur, destructeur
			LogManager () noexcept ;
			virtual ~LogManager () ;

		private :
		
			// Le logger enregistré
			nkLog::Logger* _receiver ;

		private :

			friend class nkCommon::SingletonClass<LogManager> ;
	} ;
}